//## {
#pragma TXM
#define __MACRO_NAME__    "z_KJVIEW.c"				// tab=4
#define __MACRO_TITLE__   "KANJI VIEWER"
#define __MACRO_INFO__    "mFr[A["
#define __MACRO_VER__     "1.08"					// o[W
#define __MACRO_UPDATE__  "2014/03/17"
#define __MACRO_TYPE__    "Command:   Plug-in: ~"
#define __MACRO_FOR__     "WZ 4.00F/Fe + WZ 5.03"	// mF  // ꉞ 4.00C/4.00D/4.00E/5.02l
#define __MACRO_AUTHOR__  "K-Araki"
#define __COPYRIGHT__     "Copyright(c): "
#define __WEBPAGE_URL__   "ka-web.skr.jp/"	// http://ka-web.skr.jp/
#include <_wz.h>
#include <windows.h>
// #include <windowsx.h>
////////////////////////////////////////////////////////////////////////////////
//
// ӁI
//   WZ 5.0x ŎgpꍇA5.01 ȍ~֗vAbvf[gB
//
// Information
//   ނ̊mFigjp R}h}NB
//
// Command
//   z_KJVIEW.main   "mFr[A(&K)..."    // [\]j[ɂł蓖ĂƗǂH
//
//   R}hC  wz_main.exe /fz_KJVIEW.txe ̃V[gJbgŒPƋN\B
//   F "C:\Program Files\WZ EDITOR\wz_main.exe" /fz_KJVIEW.txe
//   i V[gJbg̖O "WZ mFr[A" ȂǂƂƗǂHBj
//
// History
//   2006/01/15: ϗ̓eLXgi"*.txt"jɋLڂ邱ƂɂB
//
////////////////////////////////////////////////////////////////////////////////


//## RpC: bZ[W
#pragma warnsignmismatch-
#pragma warnlosedigit-

//## permanentϐ
permanent txstr p_szLastWord = "mFp";
permanent BOOL  p_fFirstBoot = TRUE;
permanent BOOL  p_fNoCaret   = FALSE;

//## globalϐ
static TX* g_textBox;		// eLXg{bNXp


//## 萔  // ĎgṕA̕ӂD݂ɕҏWĂ

#define __FONTNAME__     "lr "	// tHg
#define __FONTSIZE__     72				// tHgTCY   // 60  72  90

#define __TEXTBOX_Y__     9		// eLXg{bNX̍   //  7   9  10
#define __TEXTBOX_X__    72		// eLXg{bNX̉

#define __DEFAULTWORD__  "mFp"	// 擾ȂŋN̕  // ɂꍇ "" Ƃ


//## 萔: ID蓖: _CAOp
enum {
	IDD_TEXTBOX = 201,
	IDD_CLEAR,
	IDD_COPY,
	IDD_PASTE,
	IDD_PASTELASTWORD,
	IDD_HELP,
};

//## ֐錾
int __prmSave(void);	// WZ4.00C ł͂Ő錾ƂȂƂȂHHHHH


//## _CAO̕\ʒ: Shell APICu痬p

static void wndSetCenter(HWND hwnd)
{
	//  HN:Sakakibara Shell APICui"shlapi.txc"j痬pĒ܂B
	HWND hwndOwner = GetWindow(hwnd,GW_OWNER);
	if (hwndOwner) {
		mchar szClass[CCHWORD];
		GetClassName(hwndOwner,szClass,CCHWORD);
		if (!strcmp(szClass,"#32770")) {
			// I[i[_CAOȂ牽Ȃ
			return;
		}
	}
	RECT r,rWork;
	GetWindowRect(hwnd,&r);
	GetWorkRect(&rWork);
	int x,y;
	if (!hwndOwner) {
		x = (rWork.right - rectCx(&r)) / 2;
		y = (rWork.bottom - rectCy(&r)) / 2;
	} else {
		RECT rOwner;
		GetWindowRect(hwndOwner,&rOwner);
		int cx = rectCx(&r);
		int cy = rectCy(&r);
		x = rOwner.left + (rectCx(&rOwner) - cx) / 2;
		y = rOwner.top + (rectCy(&rOwner) - cy) / 2;
		if (x < 0) {
			x = 0;
		} else {
			if (x + cx > rWork.right) x = rWork.right - cx;
		}
		if (y < 0) {
			y = 0;
		} else {
			if (y + cy > rWork.bottom) y = rWork.bottom - cy;
		}
	}
	SetWindowPos(hwnd,NULL,x,y,0,0,SWP_NOSIZE|SWP_NOZORDER);
}


//## wv

static BOOL CALLBACK dlgprocHelp(HWND hwnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	if (uMsg==WM_INITDIALOG) wndSetCenter(hwnd);	// wz_main.exe /fz_KJVIEW.txe ŒPƋNɃ_CAO[ɕ\̂Œ
	return FALSE;
}

static void HelpAbout(void)
{
	txstr szTitle, szAuthor;
	sprintf(szTitle,"%s ( \"\m.c\" )  -  Ver. %s",__MACRO_TITLE__,__MACRO_VER__);
	sprintf(szAuthor,"%s%s i http://%s j",__COPYRIGHT__,__MACRO_AUTHOR__,__WEBPAGE_URL__);
	HDIALOG hd = dialog("Help - WZ MACRO");
#pragma warnfuncnotcall-
	dialogSetDlgprocTxpcode(hd,dlgprocHelp);
#pragma warnfuncnotcall+
	dialogSetNoButton(hd);
	dialogSetIntXY(hd,0,0);
	dialogCaption(hd,szTitle);
	dialogCaption(hd,"mF: "   + __MACRO_FOR__);
	dialogCaption(hd,"LastUpdate: " + __MACRO_UPDATE__);
	dialogCaption(hd,szAuthor);
	dialogSetPosY(hd,dialogGetPosY(hd)+8);
	dialogCaption(hd," Tv");
	dialogCaption(hd,"@@ނ̊mFigjp}NłB");
	dialogSetPosY(hd,dialogGetPosY(hd)+4);
	dialogCaption(hd,"@@WZ ̕ňiȓ͈̔͂IċNƑIĂ");
	dialogCaption(hd,"@@\ċN܂Bi ̋󔒂͏Oĕ\ j");
	dialogCaption(hd,"@@ÍAJ[\ʒu󔒁iXy[XA^uAsȂǁjłȂ");
	dialogCaption(hd,"@@΃J[\ʒu̒P\ċN܂B");
	dialogCaption(hd,"@@擾ȂŋN̓Tv́umFpvƂ");
	dialogCaption(hd,"@@\܂B");
	dialogCaption(hd,"@@i eLXg{bNX͕̓͂\łBj");
	dialogSetPosY(hd,dialogGetPosY(hd)+4);
	dialogCaption(hd,"@@܂AWZ ̃EBhEJĂȂԂ Windows AvP[V");
	dialogCaption(hd,"@@IɒPƂŋN邱Ƃ\łB");
	dialogCaption(hd,"@@i ڍׂ́Á@\"\m.txt\"@Bj");
	dialogSetPosY(hd,dialogGetPosY(hd)+4);
	dialogCaption(hd," [Rs[]@{^");
	dialogCaption(hd,"@@eLXg{bNX̕Rs[܂B");
	dialogSetPosY(hd,dialogGetPosY(hd)+4);
	dialogCaption(hd," [\t]@{^");
	dialogCaption(hd,"@@eLXg{bNXNAăNbv{[h̕\t܂B");
	dialogSetPosY(hd,dialogGetPosY(hd)+4);
	dialogCaption(hd," [OA̕]@{^");
	dialogCaption(hd,"@@eLXg{bNXNAđO̕\܂B");
	dialogResetInt(hd);
	dialogOpen(hd);
}


//## Nbv{[hp

static int GetClipboardSize(void)
{
	// Nbv{[h̃eLXg̃oCgԂ
	int size = 0;
	if (clipGetExistText()) size = memClipPaste(NULL,HCLIP_WIN);
	return size;
}

static void GetClipboardTopPara(txstr szWord)
{
	// szWord  Nbv{[h̕(sȍ~)̈s̕擾		// ̋󔒂͏O
	if (!clipGetExistText()) return;
	TX* textTmp = textnew();
	txDeleteText(textTmp);
	txPaste(textTmp);
	txJumpFileTop(textTmp);
	while (!txIsCurEof(textTmp)) {
		if (txGetPara(textTmp,szWord)) {
			szWord = strGetWordTop(szWord);
			if (strlen(szWord)) break;
		}
		if (!txNextPara(textTmp)) break;
	}
	textclose(textTmp);
}


//## _CAO

static void ClearInsertWord(TX* textBox, txstr szWord)
{
	// textBox NA szWord }	// szWord s͓̎ 1ŝ
	txDeleteText(textBox);
	szWord = strGetWordTop(szWord);
	if (strlen(szWord)) {
		txCurInsertBuff(textBox,szWord,strlen(szWord));
		txJumpParaEnd(textBox);
		if (!txIsCurEof(textBox)) {
			txSelectEx(textBox,CLIP_CHAR);
			txJumpFileEnd(textBox);
			txSelectDelete(textBox);
		}
		txJumpFileTop(textBox);
	}
}

static void CopyTextBox(TX* textBox)
{
	// textBox ̃̕Rs[		// I͈sRs[
	txSetUndisp(textBox);
	if (!textBox->fClip) txSelectEx(textBox,CLIP_PARACUR);
	txSelectCopyQuit(textBox);
	txSetDisp(textBox);
}

static void PasteTextBox(TX* textBox)
{
	// textBox փNbv{[h̕}	// s̏ꍇA(sȍ~)̈s
	txstr szWord;
	txSetUndisp(textBox);
	if (GetClipboardSize() <= CCHTXSTR) GetClipboardTopPara(szWord);
	else szWord = "Size Over! ( Max 260byte )";
	ClearInsertWord(textBox,szWord);	// NAĂ}	// NAȂő}Ȃ txInsert(textBox,szWord);
	txSetDisp(textBox);
}

static void FlushTextBox(TX* textBox, BOOL fNoCaret)
{
	// textBox ̕\ݒ肵čXV

	// fNoCaret: Lbg\ȂH

	strcpy(textBox->lfFaceName,__FONTNAME__);
	textBox->lfHeight = __FONTSIZE__;
	textBox->fMyFont  = 1;

	if (fNoCaret) textBox->fNoCaret = 1;

	textBox->fReadMode    = 0;
	textBox->fDispLf      = 0;
	textBox->fDispEof     = 0;
	textBox->fDispTab     = 0;
	textBox->fDispFind    = 0;
	textBox->fDispControl = 0;
	textBox->fDispComment = 0;
	textBox->fScrollBarH  = 0;
	textBox->fScrollBarV  = 0;
	textBox->fDispLine    = 0;
	textBox->fSpaceLeft   = 0;
	textBox->fDispUnder   = 0;
	textBox->fApfuBeamtab = 0; 
	textBox->nSpaceTopH   = 0;
	textBox->fWidthInfinity        = 1;
	textBox->fNoDispHeadlineString = 0;
	textBox->fDispHeadlineBold     = 0;
	textBox->fDispRightMargin      = 0;
	textBox->fEdit = 0;
	//textBox->dlgcode = DLGC_WANTALLKEYS;	// eLXg{bNX Enter̓͂\ɂ

	//txKeyLoad(textBox);
	txKeyLoadFrame(textBox);

	txFlush(textBox);
}

static BOOL CALLBACK dlgprocMain(HWND hwnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	HDIALOG hd = dialogFromHwnd(hwnd);
	switch (uMsg) {
		case WM_INITDIALOG: {
			wndSetCenter(hwnd);
			// wz_main.exe /fz_KJVIEW.txe ŒPƋNɃ_CAO[ɕ\̂Œ
			wndImeSetOpen(hwnd,TRUE);
			// mFp IME ONB
			break;
		}
		case WM_COMMAND: {
			switch (LOWORD(wParam)) {

				case IDD_CLEAR:
					txDeleteText(g_textBox);
					break;
				case IDD_COPY:
					CopyTextBox(g_textBox);
					break;
				case IDD_PASTE:
					PasteTextBox(g_textBox);
					break;
				case IDD_PASTELASTWORD:
					txDeleteText(g_textBox);
					txCurInsertBuff(g_textBox,p_szLastWord,strlen(p_szLastWord));
					break;
				case IDD_HELP:
					HelpAbout();
					break;

				case 0:
				case IDOK:
				case IDCANCEL: {
					dialogRead(hd);
					txGetPara(g_textBox,p_szLastWord);
					__prmSave();
					break;
				}

			}
			break;
		}
	}
	return FALSE;
}

static void MainDialog(BOOL fTxe, txstr szWord)
{
	// _CAO

	// fTxe   = TXENH
	// szWord = Nɕ\镶

	g_textBox = textnew();

	if (p_fFirstBoot || !strlen(szWord)) szWord = __DEFAULTWORD__;
	// p_fFirstBoot = ߂Ă̋N
	p_fFirstBoot = FALSE;

	ClearInsertWord(g_textBox,szWord);

	int lcx = 10, lcx2 = 24;
	txstr szTitle;
	sprintf(szTitle,"%s%s  -  Ver.%s",fTxe ? "WZ ":"",__MACRO_INFO__,__MACRO_VER__);
	// TXEN Windows̃vZXƃ^XNo[̕\ WZ ƕ悤ɓ "WZ " t
	HDIALOG hd = dialog(szTitle);
#pragma warnfuncnotcall-
	dialogSetDlgprocTxpcode(hd,dlgprocMain);
#pragma warnfuncnotcall+
	dialogSetNoButton(hd);
	dialogSetFocus(hd,IDD_TEXTBOX);

	dialogControlID(hd,IDD_TEXTBOX);
	dialogEditWz(hd,"mF (&L)F",g_textBox,__TEXTBOX_X__,__TEXTBOX_Y__,NULL);
	FlushTextBox(g_textBox,p_fNoCaret);

	dialogSpace(hd);
	dialogSetH(hd);
	dialogControlID(hd,IDD_CLEAR);
	dialogPushbuttonBig(hd,"NA(&D)",lcx);
	dialogControlID(hd,IDD_COPY);
	dialogPushbuttonBig(hd,"Rs[(&C)",lcx);
	dialogControlID(hd,IDD_PASTE);
	dialogPushbuttonBig(hd,"\t(&V)",lcx);
	dialogSpace(hd);
	dialogSpace(hd);
	dialogControlID(hd,IDD_PASTELASTWORD);
	dialogPushbuttonBig(hd,"OA̕(&Z)",lcx2);
	dialogSpace(hd);
	dialogSpace(hd);
	dialogControlID(hd,IDD_HELP);
	dialogPushbuttonBig(hd,"wv(&H)",lcx);
	dialogLFSetV(hd);

	dialogSpace(hd);
	dialogSpace(hd);
	dialogCheck(hd,"Lbg\Ȃ i ̋N甽f j (&N)",&p_fNoCaret);

	dialogOpen(hd);
	textclose(g_textBox);
}

//## 蓖ėp֐

void main(TX* text)
{
	// ʏN: TXENȂ WZ̋N
	txstr szWord;
	if (text->fClip) {
	// ͈͑IAiȓ̎͑I𕶎擾
		if (txIsClipInPara(text)) txGetWord(text,szWord);
	} else {
	// IA󔒂Ȃ̓J[\ʒuP擾
		TXCHAR c = txGetChar(text);
		if (!txIsCurEof(text) && !isspace(c) && c!='@') txGetWordWhole(text,szWord);  // txGetParaRear ̕ǂȁcH
	}
	MainDialog(FALSE,szWord);
}


//## PƋNpiwz_main.exe /fz_KJVIEW.txe Npj

HWND TxeMain(wchar* wszcmdline)
{
	txstr szCmdline, szWord;
	wstrtostr(wszcmdline,-1,szCmdline,CCHPATHNAME);

	// -w"" tR}hCΉ
	// -w""() 擾ł΁A̕\ċN
	BOOL fOptWord = FALSE;
	if (strstr(szCmdline,"-w\"")) {
		szWord = strstr(szCmdline,"-w\"");
		szWord = strrear(szWord,3);
		if (strchr(szWord,'"')) {
			szWord = strleft(szWord,strlen(szWord) - strlen(strchr(szWord,'"')));
			if (strlen(szWord)) fOptWord = TRUE;
			//information("%s",szDataDir);
		}
	}
	if (!fOptWord && GetClipboardSize() <= CCHTXSTR) GetClipboardTopPara(szWord);
	// -w""Ȃ̎̓Nbv{[h̕\ċN		// s̏ꍇA(sȍ~)̈ŝ
	MainDialog(TRUE,szWord);
	return NULL;
}


